; ---------------------------------------------------------------------
; Name:             Sicherungs-Ordner-berwachung v0.3
; Author:           Wolfgang Reszel fr c't
; Datum:            16.12.2004
;
; Language:         german/english
; Platform:         tested with XP
; #Includeable:     no
;
; Beschreibung:                                                (german)
; ---------------------------------------------------------------------
; Dieses Skript berwacht ein Verzeichnis auf CD-Sicherungs-Ordner.
; Die im berwachten Verzeichnis angelegten Ordner mssen wie folgt
; benannt werden.
; CD 002
; DVD 003
; DVD 004
; CD 005

; Das Skript nennt nun automatisch die CD-Ordner, so um, dass man direkt
; ablesen kann, wieviel Platz noch frei ist, oder ob ein Ordner voll ist
; und gebrannt werden kann. Unter XP lsst sich mit BurnFullMedia=yes
; einstellen, dass die CD automatisch gebrannt wird.

; Das Skript ist bei meiner Arbeit entstanden. Dort arbeiten wir mit Mac
; und Windows und wir haben ein globales Sicherungsverzeichnis, welches
; auf dem Fileserver von diesem Skript berwacht wird. Es gibt bei den
; Macs nmlich das Problem, dass die nicht immer die richtige Ordnergre
; angezeigt wird und dann Mitarbeiter die CD-Ordner ber ihr Limit mit
; Daten gefllt haben.
; ---------------------------------------------------------------------

; ---------------------------------------------------------------------
; -- Konfiguration: ---------------------------------------------------
; ---------------------------------------------------------------------

WatchPath = C:\CD-Sicherung ; Verzeichnis das berwacht werden soll

CDLimit       = 699  ; kb wenn CD komplett voll ist
CDFull        = 685  ; kb ab wann CD gebrannt werden kann
CDWarn        = 660  ; kb ab wann die CD fast voll ist

DVDLimit      = 4488 ; kb wenn DVD komplett voll ist
DVDFull       = 4300 ; kb ab wann DVD gebrannt werden kann
DVDWarn       = 4000 ; kb ab wann die DVD fast voll ist

Digits        = 3    ; Anzahle der Stellen fr die CD-Nummern

BurnFullMedia = no   ; CDs unter XP automatisch brennen?
BurnDrive     = F    ; Brenner-Laufwerk ohne Doppelpunkt

; Bezeichnungen
Full     = Voll
Empty    = Leer
Oversize = berfllt
free     = frei
finished = Gebrannt

; ---------------------------------------------------------------------
; -- Initialisierung --------------------------------------------------
; ---------------------------------------------------------------------

#SingleInstance force
#Persistent
SetTitleMatchMode, 2
BlockInput, Send

; CD-Ordner von XP ermitteln
RegRead, WinBurnDir, HKEY_CURRENT_USER, Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders, CD Burning

; Wenn kein Brennordner, dann automatisch Brennen deaktivieren
if WinBurnDir =
   BurnFullMedia = no

DelayMMSS = 0001      ; Verzgerung nach nderungsdatum

SetTimer, Watch, 5000 ; Alle 5000ms die Ordner prfen und umbenennen.

Return ; Auto-Execute-Bereich ist hier zu Ende


; Die eigentliche berwachung
Watch:
   WatchLog =
   Loop, %WatchPath%\*.*, 2, 0          ; Alle Haupt-Ordner holen
   {
      StringLeft, check, A_LoopFileName, 2  ; die ersten beiden Buchstaben
      if check in CD,DV                     ; wenn sie mit CD oder DV(D) beginnen dann ...
      {
         ; Warte ein gewisse Zeit (DelayMMSS) nach der letzten nderungszeit
         TimeDif = %A_Now%
         TimeDif -= %A_LoopFileTimeAccessed%
         if TimeDif > %DelayMMSS%
         {
            ; Durch umbenennen Prfen ob das Verzeichnis in Verwendung ist
            FileMoveDir, %A_LoopFileFullPath%    , %A_LoopFileFullPath%_tmp, R
            FileMoveDir, %A_LoopFileFullPath%_tmp, %A_LoopFileFullPath%    , R
            FErr = %ErrorLevel% ; = 0 wenn Verzeichnis nicht in Verwendung

            ;  Verzeichnisgre berechnen
            FSizeKB = 0 ; Gre initialisieren
            Loop, %A_LoopFileFullPath%\*.*, , 1
            {
               ; Gre jeder Datei addieren
               FSizeKB += %A_LoopFileSizeKB%
            }
            FSizeMB = %FSizeKB% ; Gre in MB berechnen
            FSizeMB /= 1024     ; ...

            Burn = no

            ; Wenn ! im Ordnernamen, dann wird er gerade gebrannt
            ; Wenn %finished% im Ordnernamen, dann wurde gebrannt
            ; in diesem Fall kein umbenennen mehr
            If A_LoopFileName contains !, %finished%
               FErr = dontburn

            if FErr = 0 ; Wenn kein Fehler
            {
               if check = CD ; Wenn Ordner eine CD-Ordner
               {
                  FreeMB =  %CDLimit%
                  FreeMB -= %FSizeMB%
                  FAdd   =  (%FreeMB% MB %free%)
                  Len    =  %Digits%
                  Len    += 3
                  StringLeft, FName, A_LoopFileName, %Len%
                  FNameMedia = %FName%

                  ; leerer ordner
                  if FSizeKB = 0
                     FAdd = %Empty%
                  ; fast Voll
                  if FSizeMB > %CDWarn%
                  {
                     FAdd = %Full% (%FreeMB% MB %free%)
                     Burn = yes ; Brennen ermglichen
                  }
                  ; Voll
                  if FSizeMB > %CDFull%
                  {
                     FAdd = %Full%
                     Burn = yes ; Brennen ermglichen
                  }
                  ; berfllt
                  if FSizeMB > %CDLimit%
                     FAdd = %Oversize% (%FSizeMB% MB)

                  ; Name fr Umbenennung erzeugen
                  if FAdd <>
                     FName = %FName% %FAdd%

                  ; Wenn der Name sich gendert hat, dann umbenennen
                  if FName <> %A_LoopFileName%
                  {
                     FileMoveDir, %A_LoopFileFullPath%,%A_LoopFileDir%\%FName%, R
                  }
               }
               if check = DV ; Wenn Ordner ein DVD-Ordner
               {
                  FreeMB =  %DVDLimit%
                  FreeMB -= %FSizeMB%
                  FAdd   =  (%FreeMB% MB %free%)
                  Len    =  %Digits%
                  Len    += 4
                  StringLeft, FName, A_LoopFileName, %Len%
                  FNameMedia = %FName%

                  ; Leerer Ordner
                  if FSizeKB = 0
                     FAdd = %Empty%
                  ; fast Voll
                  if FSizeMB > %DVDWarn%
                  {
                     FAdd = %Full% (%FreeMB% MB %free%)
                     Burn = yes ; Brennen ermglichen
                  }
                  ; Voll
                  if FSizeMB > %DVDFull%
                  {
                     FAdd = %Full%
                     Burn = yes ; Brennen ermglichen
                  }
                  ; berfllt
                  if FSizeMB > %DVDLimit%
                     FAdd = %Oversize% (%FSizeMB% MB)

                  ; Name fr Umbenennung erzeugen
                  if FAdd <>
                     FName = %FName% %FAdd%

                  ; Wenn der Name sich gendert hat, dann umbenennen
                  if FName <> %A_LoopFileName%
                  {
                     FileMoveDir, %A_LoopFileFullPath%, %A_LoopFileDir%\%FName%, R
                  }
               }

               ; Wenn brennen mglich und erlaubt
               If BurnFullMedia = yes
               If Burn = yes
               {
                  ; Umbenennen, damit erkannt werden kann, das der Ordner gerade
                  ; gebrannt wird
                  FileMoveDir, %A_LoopFileDir%\%FName%, %A_LoopFileDir%\%FName%!, R

                  ; Medien-Typ
                  If FName contains DVD
                     Type = DVD
                  else
                     Type = CD

                  MsgBox, 36, %Type% brennen, Soll %FNameMedia% gebrannt werden?
                  IfMsgBox, yes
                  {
                     Drive, Eject, %BurnDrive%:, 0 ; Brenner auswerfen
                     lastdrivestatus =             ; letzten Status lschen
                     Loop                          ; Endlosschleife
                     {
                        DriveGet, drivestatus ,StatusCD, %BurnDrive%: ; Laufwerkstatus ermitteln
                        if lastdrivestatus <> %drivestatus%           ; Wenn Status gendert Fenster aktualisieren
                           Splashtexton,,22, Medium einlegen (%drivestatus%), Bitte eine %TYPE% einlegen ...
                        lastdrivestatus = %drivestatus%               ; letzten Status merken

                        GetKeyState, stateESC, ESC   ; Abbruch mit ESC
                        if stateESC = D
                           break

                        if drivestatus = stopped     ; Schleife abbrechen, wenn CD erkannt wurde
                           break

                        GetKeyState, state, LButton  ; Bei Mausklick im Fenster CD einfahren
                        if state = D
                        {
                           MouseGetPos,,, id
                           WinGetTitle, title, ahk_id %id%
                           if title contains Medium einlegen
                              Drive, Eject, %BurnDrive%:, 1
                        }

                     }
                     Splashtextoff
                     If stateESC <> D ; Wenn nicht abgebrochen
                     {
                        ; Dateien Kopieren (mit einem FileCopyDir wrde der CD-Ordner gebrannt und nicht der Inhalt)
                        Splashtexton,,22, %FNameMedia% vorbereiten, Dateien werden kopiert  ...
                        Loop, %A_LoopFileDir%\%FName%!\*.*, 2, 0
                        {
                           FileCopyDir, %A_LoopFileFullPath%, %WinBurnDir%, 1
                        }
                        Loop, %A_LoopFileDir%\%FName%!\*.*, 0, 0
                        {
                           FileCopy, %A_LoopFileFullPath%, %WinBurnDir%, 1
                        }
                        Splashtextoff

                        Sleep, 2000                                      ; kleine Pause
                        Run, %BurnDrive%:\                               ; Brennlaufwerk im Explorer ffnen
                        Sleep, 6000                                      ; etwas grere Pause
                        WinWait, (%BurnDrive%:)                          ; Warten bis Fenster da
                        WinActivate, (%BurnDrive%:)
                        WinWaitActive, (%BurnDrive%:)
                        Send, !D{Enter}                                  ; Datei->Brennen ausfhren
                        WinWait, Assistent zum Schreiben von CDs         ; Auf Fenster warten
                        WinActivate, Assistent zum Schreiben von CDs
                        WinWaitActive, Assistent zum Schreiben von CDs
                        Send, %FNameMedia%                               ; Name der CD
                        Send, !A                                         ; Assistent automatisch schlieen
                        Send, !W                                         ; Weiter
                        WinWait, Assistent zum Schreiben von CDs, auf die CD geschrieben.        ; Warten
                        WinActivate, Assistent zum Schreiben von CDs, auf die CD geschrieben.
                        WinWaitActive, Assistent zum Schreiben von CDs, auf die CD geschrieben.
                        Send, {Enter}                                    ; Fertig
                        ; Umbenennen, CD fertig gebrannt
                        FileMoveDir, %A_LoopFileDir%\%FName%!, %A_LoopFileDir%\%FNameMedia% %finished%, R
                     }
                  }
               }
            }
            else
            {
               WatchLog = %WatchLog%Error: %A_LoopFileName% #
            }
         }
      }
      Menu, TRAY, Tip, %WatchLog% ; Traytip wenn Fehler
   }
return:

